﻿var smsInvitationStatus = {
    context: $(".v-smsInvitationStatus"),
    datatable: null,
    initialize: function () {
        var distributionId = $(".distributionId").val();

        this.datatable = $(".h-sms-history-table", smsInvitationStatus.context).a4datatable({            
            ajaxAction: a4.getSurveyAction("GetSMSDistributionRespondents", "Distribute"),
            ajaxParams: { "distributionId": distributionId },
            customStyle: "compact",
            displayColumnSelector: false,
            displaySearchBox: canReadPII,
            columns: [
                { "Data": "Message", "Tooltip": true },
                { "Name": "RespondentId", "Title": resources.Id, "Data": "RespondentId", "Width": (canReadPII ? "70px" : "") },
                { "Name": "RespondentPhone", "Title": resources.Phone, "Data": "RespondentPhone", "Visible": canReadPII, "HideInSelector": !canReadPII },
                { "Name": "Status", "Title": resources.Status, "Data": "Status", "Width": (canReadPII ? "100px" : "") },
                { "Name": "AccessDate", "Title": resources.SentDate, "Data": "AccessDate", "Width": (canReadPII ? "130px" : "") }
            ],
            quickFilter: {
                "AjaxParam": "status",
                "Items": [
                    { "Label": resources.Sent, "AjaxParams": { "status": '1' } },
                    { "Label": resources.Delivered, "AjaxParams": { "status": '6' } },
                    { "Label": resources.Undelivered, "AjaxParams": { "status": '7,8,9,10' } }
                ]
            }           
        });

        if ($(".chart").length > 0) {
            a4.callServerMethod(a4.getSurveyAction("SMSDistributionStatusChart", "Distribute"), { id: distributionId }, function (result) {
                a4.initChart($(".chart"), result);
            });
        }
    },
    bindEvents: function () {
        smsInvitationStatus.context.on("click", ".h-exportRespondents", function () {
            a4.showBusyBox();

            var ajaxParams = smsInvitationStatus.datatable.a4datatable("getAjaxParams");

            a4.callServerMethod(a4.getSurveyAction("ExportSMSDistributionRespondents", "Distribute"), ajaxParams,
            function (result) {
                a4.hideBusyBox();
                window.location = a4.getSurveyAction("GetSMSDistributionRespondentsFile", "Distribute", { fileName: result });
            },
            function (error) {
                a4.onAjaxPageMethodError(error);
            });
        });
    }
}

$(document).ready(function () {
    if (smsInvitationStatus.context.length > 0) {
        smsInvitationStatus.initialize();
        smsInvitationStatus.bindEvents();
    }
});